/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.client.AccessoryArmorRenderer;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.ArmorRenderingExtension;
import io.wispforest.accessories.api.client.ClientRenderingUtils;
import io.wispforest.accessories.api.client.DefaultAccessoryRenderer;
import io.wispforest.accessories.api.client.EmptyRenderer;
import io.wispforest.accessories.api.client.WrappedAccessoryRenderer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryCustomRendererComponent;
import io.wispforest.accessories.api.components.AccessoryRenderOverrideComponent;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5151;
import net.minecraft.class_583;
import net.minecraft.class_7923;
import net.minecraft.class_8921;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesRendererRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<class_2960, Supplier<AccessoryRenderer>> RENDERERS = new HashMap<class_2960, Supplier<AccessoryRenderer>>();
    private static final BiMap<class_2960, AccessoryRenderer> CACHED_RENDERERS = HashBiMap.create();

    public static void registerRenderer(class_2960 location, Supplier<AccessoryRenderer> renderer) {
        RENDERERS.put(location, renderer);
    }

    public static void registerRenderer(class_1792 item, Supplier<@NotNull AccessoryRenderer> renderer) {
        AccessoriesRendererRegistry.registerRenderer(AccessoriesRendererRegistry.getRendererId(item), renderer);
    }

    public static void registerNoRenderer(class_1792 item) {
        AccessoriesRendererRegistry.registerRenderer(item, EmptyRenderer::new);
    }

    public static void registerArmorRendering(class_1792 item) {
        if (item instanceof class_5151 && !AccessoriesRendererRegistry.hasRenderer(item)) {
            AccessoriesRendererRegistry.registerRenderer(item, () -> new AccessoryArmorRenderer(){});
        }
    }

    public static boolean hasRenderer(class_1792 item) {
        return AccessoriesRendererRegistry.hasRenderer(class_7923.field_41178.method_10221((Object)item));
    }

    public static boolean hasRenderer(class_2960 rendererId) {
        return RENDERERS.containsKey(rendererId);
    }

    public static AccessoryRenderer getRenderer(class_1799 stack) {
        boolean armorRenderOverride;
        if (stack.method_57826(AccessoriesDataComponents.CUSTOM_RENDERER) && !stack.method_31574(class_1802.field_27023)) {
            return DataDrivenAccessoryRenderer.INSTANCE;
        }
        AccessoryRenderOverrideComponent renderOverrides = (AccessoryRenderOverrideComponent)stack.method_57825(AccessoriesDataComponents.RENDER_OVERRIDE, (Object)AccessoryRenderOverrideComponent.DEFAULT);
        Boolean defaultRenderOverride = renderOverrides.defaultRenderOverride();
        if (defaultRenderOverride != null) {
            if (defaultRenderOverride.booleanValue()) {
                return DefaultAccessoryRenderer.INSTANCE;
            }
            if (AccessoriesAPI.isDefaultAccessory(AccessoriesAPI.getOrDefaultAccessory(stack))) {
                return new EmptyRenderer();
            }
        }
        if (armorRenderOverride = renderOverrides.useArmorRenderer()) {
            return ArmorRenderingExtension.RENDERER;
        }
        return AccessoriesRendererRegistry.getRenderer(stack.method_7909());
    }

    public static AccessoryRenderer getRenderer(class_1792 item) {
        class_2960 id = AccessoriesRendererRegistry.getRendererId(item);
        AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(id);
        if (!CACHED_RENDERERS.containsKey((Object)id)) {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        }
        if (renderer instanceof EmptyRenderer && Accessories.config().clientOptions.forceNullRenderReplacement()) {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        }
        return renderer == null ? new EmptyRenderer() : renderer;
    }

    @Nullable
    public static AccessoryRenderer getRenderer(class_2960 rendererId) {
        return (AccessoryRenderer)CACHED_RENDERERS.get((Object)rendererId);
    }

    @Nullable
    public static class_2960 getRendererId(AccessoryRenderer renderer) {
        return (class_2960)CACHED_RENDERERS.inverse().get((Object)renderer);
    }

    public static class_2960 getRendererId(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item);
    }

    @ApiStatus.Internal
    public static void onReload() {
        CACHED_RENDERERS.clear();
        RENDERERS.forEach((rendererId, supplier) -> {
            class_2960 otherRendererId;
            AccessoryRenderer renderer = (AccessoryRenderer)supplier.get();
            if (renderer == null) {
                LOGGER.warn("A given renderer [{}] was found to be returning a null renderer which is not advised as method to indicate no rendering!", rendererId);
                renderer = new EmptyRenderer();
            }
            if ((otherRendererId = (class_2960)CACHED_RENDERERS.inverse().get((Object)renderer)) != null) {
                LOGGER.warn("A given renderer [{}] was found to be shared by another renderer [{}], such will be wrapped to prevent crashing and should be reported!", rendererId, (Object)otherRendererId);
                renderer = new WrappedAccessoryRenderer(renderer);
            }
            CACHED_RENDERERS.put(rendererId, (Object)renderer);
        });
    }

    @Deprecated(forRemoval=true)
    public static AccessoryRenderer getRender(class_1799 stack) {
        return AccessoriesRendererRegistry.getRenderer(stack);
    }

    @Deprecated(forRemoval=true)
    public static AccessoryRenderer getRender(class_1792 item) {
        return AccessoriesRendererRegistry.getRenderer(item);
    }

    static {
        AccessoriesRendererRegistry.registerRenderer(class_1802.field_27023, BundleAccessoryRenderer::new);
    }

    @ApiStatus.Internal
    public static class DataDrivenAccessoryRenderer
    implements AccessoryRenderer {
        public static final DataDrivenAccessoryRenderer INSTANCE = new DataDrivenAccessoryRenderer();

        @Override
        public <M extends class_1309> void render(class_1799 stack, SlotReference reference, class_4587 matrices, class_583<M> model, class_4597 multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            AccessoryCustomRendererComponent data = (AccessoryCustomRendererComponent)stack.method_57824(AccessoriesDataComponents.CUSTOM_RENDERER);
            if (data == null) {
                return;
            }
            ClientRenderingUtils.handle(stack, reference.entity(), null, model, matrices, multiBufferSource, partialTicks, 0xF000F0, class_4608.field_21444, -1, data.renderingFunctions());
        }

        @Override
        public <M extends class_1309> void renderOnFirstPerson(class_1306 arm, class_1799 stack, SlotReference reference, class_4587 matrices, class_583<M> model, class_4597 multiBufferSource, int light) {
            AccessoryCustomRendererComponent data = (AccessoryCustomRendererComponent)stack.method_57824(AccessoriesDataComponents.CUSTOM_RENDERER);
            if (data == null) {
                return;
            }
            class_1309 targetEntity = reference.entity();
            class_8921 tickRateManager = targetEntity.method_37908().method_54719();
            float partialTicks = class_310.method_1551().method_60646().method_60637(!tickRateManager.method_54746((class_1297)targetEntity));
            ClientRenderingUtils.handle(stack, targetEntity, arm, model, matrices, multiBufferSource, partialTicks, 0xF000F0, class_4608.field_21444, -1, data.renderingFunctions());
        }

        @Override
        public boolean shouldRenderInFirstPerson(class_1306 arm, class_1799 stack, SlotReference reference) {
            return true;
        }
    }

    @ApiStatus.Internal
    private static class BundleAccessoryRenderer
    implements AccessoryRenderer {
        private BundleAccessoryRenderer() {
        }

        @Override
        public <M extends class_1309> void render(class_1799 stack, SlotReference reference, class_4587 matrices, class_583<M> model, class_4597 multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            class_9276 contents = (class_9276)stack.method_57824(class_9334.field_49650);
            if (contents == null) {
                return;
            }
            DataDrivenAccessoryRenderer.INSTANCE.render(stack, reference, matrices, model, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            Iterable iterable = contents.method_57421();
            if (iterable instanceof List) {
                List list = (List)iterable;
                for (int i = 0; i < list.size(); ++i) {
                    AccessoryRenderer renderer;
                    class_1799 innerStack = (class_1799)list.get(i);
                    if (innerStack.method_7960() || (renderer = AccessoriesRendererRegistry.getRenderer(innerStack)).isEmpty()) continue;
                    matrices.method_22903();
                    try {
                        renderer.render(innerStack, AccessoryNestUtils.create(reference, i), matrices, model, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("[BundleAccessoryRenderer] Unable to render a given inner item stack due the following error: ", e);
                    }
                    matrices.method_22909();
                }
            }
        }

        @Override
        public <M extends class_1309> void renderOnFirstPerson(class_1306 arm, class_1799 stack, SlotReference reference, class_4587 matrices, class_583<M> model, class_4597 multiBufferSource, int light) {
            class_9276 contents = (class_9276)stack.method_57824(class_9334.field_49650);
            if (contents == null) {
                return;
            }
            DataDrivenAccessoryRenderer.INSTANCE.renderOnFirstPerson(arm, stack, reference, matrices, model, multiBufferSource, light);
            Iterable iterable = contents.method_57421();
            if (iterable instanceof List) {
                List list = (List)iterable;
                for (int i = 0; i < list.size(); ++i) {
                    class_1799 innerStack = (class_1799)list.get(i);
                    if (innerStack.method_7960()) continue;
                    AccessoryRenderer renderer = AccessoriesRendererRegistry.getRenderer(innerStack);
                    SlotReference ref = AccessoryNestUtils.create(reference, i);
                    if (renderer.isEmpty() || !renderer.shouldRenderInFirstPerson(arm, innerStack, ref)) continue;
                    matrices.method_22903();
                    try {
                        renderer.renderOnFirstPerson(arm, innerStack, ref, matrices, model, multiBufferSource, light);
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("[BundleAccessoryRenderer] Unable to render a given inner item stack due the following error: ", e);
                    }
                    matrices.method_22909();
                }
            }
        }
    }
}

